﻿using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.VisualStudio.TestTools.UnitTesting;

// ReSharper disable ConvertToLambdaExpression
// ReSharper disable LoopCanBeConvertedToQuery
// ReSharper disable ReturnValueOfPureMethodIsNotUsed
// ReSharper disable IteratorMethodResultIsIgnored
// ReSharper disable PossibleMultipleEnumeration
// ReSharper disable RedundantAssignment
#pragma warning disable 219

namespace LinqAsMonads
{
	[TestClass]
	public class _2_LinqDigging
	{
		[TestMethod]
		public void WhatIf()
		{
			int myNumber = 42;

			if (myNumber % 2 == 0)
			{
				Console.WriteLine("The number is even!");
			}
			else
			{
				Console.WriteLine("The number is odd!");
			}
		}

		[TestMethod]
		public void CustomIf()
		{
			int myNumber = 42;

			IfElse(myNumber % 2 == 0,
				() => Console.WriteLine("The number is even!"),
				() => Console.WriteLine("The number is odd!"));
		}

		private static void IfElse(bool decision, Action success, Action failure)
		{
			if (decision)
				success();
			else
				failure();
		}

		[TestMethod]
		public void ForEach()
		{
			foreach (var i in new[] { "a", "b", "c" })
			{
				var squareI = i + i;
				Console.WriteLine(squareI);
			}

			foreach (var i in new int[] { })
			{
				// Das wird nie ausgeführt!
				Console.WriteLine(i);
			}
		}

		[TestMethod]
		public void CustomForEach()
		{
			RunForEach(
				new[] { 1, 2, 3 },
				i =>
				{
					var squareI = i * i;
					Console.WriteLine(squareI);
				});
		}

		private static void RunForEach<T>(IEnumerable<T> enumerable, Action<T> action)
		{
			foreach (var element in enumerable)
				action(element);
		}

		private static void RunForEachAlt<T>(IEnumerable<T> enumerable, Action<T> action)
		{
			var er = enumerable.GetEnumerator();

			while (er.MoveNext())
				action(er.Current);
		}

		[TestMethod]
		public void MutipleForEach()
		{
			foreach (var i in new[] { "a", "b", "c" })
				foreach (var j in new[] { 1, 2, 3 })
				{
					Console.WriteLine(i + j);
				}




			RunForEach(new[] { "a", "b", "c" },
				i =>
				{
					RunForEach(new[] { 1, 2, 3 },
						j =>
						{
							Console.WriteLine(i + j);
						});
				});
		}

		[TestMethod]
		public void CustomQCS()
		{
			IEnumerable<string> result = from i in new[] { "a", "b", "c" }
										 from j in new[] { 1, 2, 3 }

										 select i + j;


			RunForEach(new[] { "a", "b", "c" },
				i =>
				{
					RunForEach(new[] { 1, 2, 3 },
						j =>
						{
							Console.WriteLine(i + j);
						});
				});


			var result2 = EvaluateEach(new[] { "a", "b", "c" },
				i =>
				{
					return EvaluateEach(new[] { 1, 2, 3 },
						j =>
						{
							return i + j;
						});
				});
		}

		private static IEnumerable<R> EvaluateEach<T, R>(IEnumerable<T> enumerable, Func<T, R> f)
		{
			foreach (var element in enumerable)
				yield return f(element);
		}

		[TestMethod]
		public void ToCqs()
		{
			var result2 =
				EvaluateEach(new[] { "a", "b", "c" }, i =>
					EvaluateEach(new[] { 1, 2, 3 }, j =>
						i + j));





			result2 =
				new[] { "a", "b", "c" }.EvaluateEach(i =>
					new[] { 1, 2, 3 }.EvaluateEach(j =>
						i + j));





			result2 =
				new[] { "a", "b", "c" }.Select(i =>
					new[] { 1, 2, 3 }.Select(j =>
						i + j));





			IEnumerable<string> result3;

			result3 = from i in new[] { "a", "b", "c" }
			          from j in new[] { 1, 2, 3 }

			          select i + j;





			result3 =
				new[] { "a", "b", "c" }.SelectMany(i =>
					new[] { 1, 2, 3 }.SelectMany(j =>
						new[] { i + j }));





			result3 =
				new[] { "a", "b", "c" }.SelectMany(i =>
					new[] { 1, 2, 3 }.SelectMany(j =>
						Return(i + j)));
		}

		private static IEnumerable<T> Return<T>(T t)
		{
			return new[] { t };
		}
	}
}

static class Extensions
{
	public static IEnumerable<R> EvaluateEach<T, R>(this IEnumerable<T> enumerable, Func<T, R> f)
	{
		foreach (var element in enumerable)
			yield return f(element);
	}
}

// ReSharper restore ConvertToLambdaExpression
// ReSharper restore LoopCanBeConvertedToQuery
// ReSharper restore IteratorMethodResultIsIgnored
// ReSharper restore ReturnValueOfPureMethodIsNotUsed
// ReSharper restore PossibleMultipleEnumeration
// ReSharper restore RedundantAssignment
#pragma warning restore 219